/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.frame;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.IKeyframeTypeSerializer;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.frame.FrameProviderType;
import net.minecraft.util.ResourceLocation;

public class SingleFrameProvider
implements IKeyframeProvider {
    private final Map<AnimationStage, IKeyframe> frames;

    public SingleFrameProvider(IFrameConstructor frameConstructor) {
        FrameBuilder builder = new FrameBuilder();
        frameConstructor.construct(builder);
        if (!builder.hasAddedFrame()) {
            throw new IllegalArgumentException("Cannot construct empty keyframe provider!");
        }
        this.frames = builder.frames;
    }

    private SingleFrameProvider(Map<AnimationStage, IKeyframe> frames) {
        this.frames = frames;
    }

    public static SingleFrameProvider fromExistingMap(Map<AnimationStage, IKeyframe> frames) {
        return new SingleFrameProvider(frames);
    }

    static SingleFrameProvider jsonLoaded(Map<AnimationStage, IKeyframe> frames) throws JsonParseException {
        if (frames.isEmpty()) {
            throw new JsonSyntaxException("Single frame provider must contain atleast one keyframe");
        }
        return new SingleFrameProvider(frames);
    }

    @Override
    public IKeyframe getCurrentFrame(AnimationStage stage, float progress, int frameIndex) {
        return AnimationUtils.safeRet(this.frames, stage, Keyframes.none());
    }

    @Override
    public IKeyframe getOldFrame(AnimationStage stage, int frameIndex) {
        return Keyframes.none();
    }

    @Override
    public boolean shouldAdvance(AnimationStage stage, float progress, int frameIndex) {
        return false;
    }

    @Override
    public IAnimationEvent[] getEvents() {
        return IAnimationEvent.NO_EVENTS;
    }

    @Override
    public FrameProviderType<?> getType() {
        return FrameProviderType.SINGLE;
    }

    @Override
    public Map<AnimationStage, IKeyframe[]> getFrameMap() {
        TreeMap<AnimationStage, IKeyframe[]> map = AnimationUtils.createSortedMap();
        this.frames.forEach((k, v) -> map.put((AnimationStage)k, new IKeyframe[]{v}));
        return map;
    }

    @Override
    public void initCache(Map<AnimationStage, Integer> cache) {
        for (AnimationStage stage : this.frames.keySet()) {
            cache.put(stage, 0);
        }
    }

    public static class Serializer
    implements IKeyframeTypeSerializer<SingleFrameProvider> {
        @Override
        public void serialize(JsonObject data, SingleFrameProvider provider, JsonSerializationContext context) {
            for (Map.Entry entry : provider.frames.entrySet()) {
                data.add(((AnimationStage)entry.getKey()).toString(), context.serialize(entry.getValue(), IKeyframe.class));
            }
        }

        @Override
        public SingleFrameProvider deserialize(JsonObject source, JsonDeserializationContext context, IAnimationEvent[] events) throws JsonParseException {
            HashMap<AnimationStage, IKeyframe> map = new HashMap<AnimationStage, IKeyframe>();
            for (Map.Entry entry : source.entrySet()) {
                String stageKey = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                AnimationStage stage = Registries.ANIMATION_STAGES.getElement(new ResourceLocation(stageKey));
                if (stage == null) {
                    throw new JsonSyntaxException("Unknown animation stage: " + stageKey);
                }
                if (!element.isJsonObject()) {
                    throw new JsonSyntaxException("Not a Json object!");
                }
                IKeyframe frame = (IKeyframe)context.deserialize(element, IKeyframe.class);
                map.put(stage, Objects.requireNonNull(frame));
            }
            return SingleFrameProvider.jsonLoaded(map);
        }
    }

    public static class FrameBuilder {
        private final Map<AnimationStage, IKeyframe> frames = new HashMap<AnimationStage, IKeyframe>();
        private boolean modified;

        public FrameBuilder define(AnimationStage stage, IKeyframe iKeyframe) {
            if (this.frames.put(stage, iKeyframe) != null) {
                throw new UnsupportedOperationException("Cannot add another frame definition for " + stage.getKey().toString() + " stage!");
            }
            this.modified = true;
            return this;
        }

        private boolean hasAddedFrame() {
            return this.modified;
        }
    }

    @FunctionalInterface
    public static interface IFrameConstructor {
        public void construct(FrameBuilder var1);
    }
}

